//================================================================================
// TheDanes Skinmanager
//================================================================================
class DanesSkinManager expands Mutator config(DanesSkinManager);

var bool bIsMalePlayer, bPlayerIsClan;

var config string ClanTag1, ClanTag2;
var config int MaleClanModel1, MaleClanModel2, FemaleClanModel1, FemaleClanModel2, MaleGuestModel, FemaleGuestModel;
var config string MaleClanSkin1, MaleClanFace1, FemaleClanSkin1, FemaleClanFace1;
var config string MaleClanSkin2, MaleClanFace2, FemaleClanSkin2, FemaleClanFace2;
var config string MaleGuestSkin, MaleGuestFace, FemaleGuestSkin, FemaleGuestFace;

function string ParseOption( string Options, string InKey )
{
	local string Pair, Key, Value;
	while( GrabOption( Options, Pair ) )
	{
		GetKeyValue( Pair, Key, Value );
		if( Key ~= InKey )
			return Value;
	}
	return "";
}

function bool GrabOption( out string Options, out string Result )
{
	if( Left(Options,1)=="?" )
	{
		// Get result.
		Result = Mid(Options,1);
		if( InStr(Result,"?")>=0 )
			Result = Left( Result, InStr(Result,"?") );

		// Update options.
		Options = Mid(Options,1);
		if( InStr(Options,"?")>=0 )
			Options = Mid( Options, InStr(Options,"?") );
		else
			Options = "";

		return true;
	}
	else return false;
}

function int GetIntOption( string Options, string ParseString, int CurrentValue)
{
	local string InOpt;

	InOpt = ParseOption( Options, ParseString );
	if ( InOpt != "" )
	{
		log(ParseString@InOpt);
		return int(InOpt);
	}	
	return CurrentValue;
}

function GetKeyValue( string Pair, out string Key, out string Value )
{
	if( InStr(Pair,"=")>=0 )
	{
		Key   = Left(Pair,InStr(Pair,"="));
		Value = Mid(Pair,InStr(Pair,"=")+1);
	}
	else
	{
		Key   = Pair;
		Value = "";
	}
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{

	local int i;
	local string InName, InPassword, InSkin, InFace, InChecksum;
	local int InTeam;
	local PlayerPawn NewPlayer;

	Super.ModifyLogin(SpawnClass, Portal, Options);

	// Get URL options.
	InName     = Left(ParseOption ( Options, "Name"), 20); // Playername som virker yehaw!!
	InTeam     = GetIntOption( Options, "Team", 255 ); // default to "no team"
	InSkin	   = ParseOption ( Options, "Skin"    );
	InFace     = ParseOption ( Options, "Face"    );
	
	// test om alle oplysninger er korrekte
	log("--------------------------------");
	log("PlayerName: "@InName);
	log("PlayerTeam: "@InTeam);
	log("ModelClass: "@SpawnClass);
	log("Skin      : "@InSkin);
	log("Face      : "@InFace);
	log("--------------------------------");	

	// find playermodel og st bIsMalePlayer til korrekt vrdi

	if ((SpawnClass == class'Botpack.TMale1') || (SpawnClass == class'Botpack.TMale2') || (SpawnClass == class'Botpack.TBoss') || (SpawnClass == class'MultiMesh.TNali') || (SpawnClass == class'MultiMesh.TCow') || (SpawnClass == class'MultiMesh.TSkaarj'))
		{
		log("Player: "@InName$" is using a male model");
		bIsMalePlayer = True;
		}
	else
		{
		bIsMalePlayer = False;
		log("Player: "@InName$" is using a female or unknown model");
		}


	// her skal player s modificeres ud fra InName som PlayerName, kig i GameInfo scriptet for mulighedder.

	// check om player er clan medlem af clan 1
	if ((InStr(InName, ClanTag1) != -1) && (ClanTag1 != ""))
		{
		// player is member of clan1
		bPlayerIsClan = True;
		log("Player: "@InName$" is a wearing ClanTag1.");
		if ( bIsMalePlayer ) // check om player er male model
			{
			if ( MaleClanModel1 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				}
			else if ( MaleClanModel1 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				}
			else if ( MaleClanModel1 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				}
			else if ( MaleClanModel1 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				}
			else if ( MaleClanModel1 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				}
			else
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				}
			InSkin = MaleClanSkin1;
			InFace = MaleClanFace1;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		else
			{
			if ( FemaleClanModel1 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				}
			else
				{
				SpawnClass = class'BotPack.TFemale2';
				}
			InSkin = FemaleClanSkin1;
			InFace = FemaleClanFace1;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		}

	// check om player er clan medlem af clan 2
	else if ((InStr(InName, ClanTag2) != -1) && (ClanTag2 != ""))
		{
		// player is member of clan2
		bPlayerIsClan = True;
		log("Player: "@InName$" is a wearing ClanTag2.");
		if ( bIsMalePlayer ) // check om player er male model
			{
			if ( MaleClanModel2 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				}
			else if ( MaleClanModel2 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				}
			else if ( MaleClanModel2 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				}
			else if ( MaleClanModel2 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				}
			else if ( MaleClanModel2 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				}
			else
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				}
			InSkin = MaleClanSkin2;
			InFace = MaleClanFace2;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		else
			{
			if ( FemaleClanModel2 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				}
			else
				{
				SpawnClass = class'BotPack.TFemale2';
				}
			InSkin = FemaleClanSkin2;
			InFace = FemaleClanFace2;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		}

	// player er ikke clan1 eller clan2, s player er guest
	else
		{
		// player is a guest
		bPlayerIsClan = False;
		log("Player: "@InName$" is not wearing any clantags.");
		if ( bIsMalePlayer ) // check om player er male model
			{
			if ( MaleGuestModel == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				}
			else if ( MaleGuestModel == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				}
			else if ( MaleGuestModel == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				}
			else if ( MaleGuestModel == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				}
			else if ( MaleGuestModel == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				}
			else
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				}
			InSkin = MaleGuestSkin;
			InFace = MaleGuestFace;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		else
			{
			if ( FemaleGuestModel == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				}
			else
				{
				SpawnClass = class'BotPack.TFemale2';
				}
			InSkin = FemaleGuestSkin;
			InFace = FemaleGuestFace;
			log("Player: "@InName$" has been set to use: Skin: "@InSkin$", Face: "@InFace);
			}
		}

}

